function y = formfactor (x);
% y = formfactor(x)
%
% Calculate the form factor, definded as 4*pi*A/P^2, where A is the area
% of an object and P is its perimeter.
%
% In:
%  x          binary image
%
% Out:
%  y          vector of form factors
%
% Antti Niemist 2009/04/01

[lab,N] = bwlabel(x);
stats = regionprops(lab,'Area');
[B,L] = bwboundaries(x,'noholes');

for k = 1:N
  boundary=B{k};
  delta_sq = diff(boundary).^2;
  perimeter = sum(sqrt(sum(delta_sq,2)));
  area = stats(k).Area;
  y(k) = 4*pi*area/perimeter^2;
end
